package gov.va.med.mhv.calendar.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "CAL_TO_DO")
public class ToDoTask implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "TO_DO_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long toDoId;

	@Column(name = "SUBJECT")
	private String subject;

	@Column(name = "DESCRIPTION")
	private String description;

	@Column(name = "DUE_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date dueDate;

	@Column(name = "REMINDER_INTERVAL")
	private String reminderInterval;

	@Column(name = "REMINDER_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date reminderDate;

	@Column(name = "STATUS")
	private String toDoStatus;

	@Column(name = "USER_PROFILE_USER_PROFILE_ID")
	private Long userProfileId;
	
	@Column(name = "OPLOCK")
	private Integer oplock;

	public Long getToDoId() {
		return toDoId;
	}

	public void setToDoId(Long toDoId) {
		this.toDoId = toDoId;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getDueDate() {
		return dueDate;
	}

	public void setDueDate(Date dueDate) {
		this.dueDate = dueDate;
	}

	public String getReminderInterval() {
		return reminderInterval;
	}

	public void setReminderInterval(String reminderInterval) {
		this.reminderInterval = reminderInterval;
	}

	public Date getReminderDate() {
		return reminderDate;
	}

	public void setReminderDate(Date reminderDate) {
		this.reminderDate = reminderDate;
	}

	public String getToDoStatus() {
		return toDoStatus;
	}

	public void setToDoStatus(String toDoStatus) {
		this.toDoStatus = toDoStatus;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

}
